#include "common_header.h"
#include "skybox.h"

bool CSkybox::loadSkybox()
{
	char *FileNames[] = {
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_ft.jpg",
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_bk.jpg",
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_dn.jpg",
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_up.jpg",
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_rt.jpg",
		"..\\10.) Skybox - V6\\release\\textures\\jajlands1_lf.jpg"
	};

	if(!Texture.loadTextureCubeMap(FileNames))
	{
		return false;
	}

	vec3 *SkyBoxVertices = new vec3[36];

	int v = 0;

	// +x = right
	SkyBoxVertices[v++] = vec3( 1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f,  1.0f);
	SkyBoxVertices[v++] = vec3( 1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f, -1.0f);
	// -x = left
	SkyBoxVertices[v++] = vec3(-1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f, -1.0f);
	SkyBoxVertices[v++] = vec3(-1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f,  1.0f);
	// +y = top
	SkyBoxVertices[v++] = vec3(-1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f,  1.0f);
	SkyBoxVertices[v++] = vec3( 1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f, -1.0f);
	// -y = bottom
	SkyBoxVertices[v++] = vec3(-1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f, -1.0f);
	SkyBoxVertices[v++] = vec3( 1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f,  1.0f);
	// +z = back
	SkyBoxVertices[v++] = vec3( 1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f,  1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f,  1.0f);
	SkyBoxVertices[v++] = vec3(-1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f,  1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f,  1.0f);
	// -z = front
	SkyBoxVertices[v++] = vec3(-1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f, -1.0f, -1.0f); SkyBoxVertices[v++] = vec3( 1.0f,  1.0f, -1.0f);
	SkyBoxVertices[v++] = vec3( 1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f,  1.0f, -1.0f); SkyBoxVertices[v++] = vec3(-1.0f, -1.0f, -1.0f);

	glGenBuffers(1, &VBO);
	
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, 36 * 3 * 4, SkyBoxVertices, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	delete [] SkyBoxVertices;

	glGenVertexArrays(1, &VAO);

	glBindVertexArray(VAO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 3 * 4, (void*)0);
	glEnableVertexAttribArray(0);
	glBindVertexArray(0);

	return true;
}

void CSkybox::renderSkybox()
{
	glBindTexture(GL_TEXTURE_CUBE_MAP, Texture);
	glBindVertexArray(VAO);
	glDrawArrays(GL_TRIANGLES, 0, 36);
	glBindVertexArray(0);
	glBindTexture(GL_TEXTURE_CUBE_MAP, 0);
}

void CSkybox::releaseSkybox()
{
	Texture.releaseTexture();
	glDeleteBuffers(1, &VBO);
	glDeleteVertexArrays(1, &VAO);
}
